/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry;

import com.google.common.collect.ImmutableList;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.feature.placement.ContinentsFilter;
import com.stevekung.fishofthieves.feature.placement.VegetationFilter;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTFeatures;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class FOTPlacements {
    public static final ResourceKey<PlacedFeature> FISH_BONE = FOTPlacements.createKey("fish_bone");
    public static final ResourceKey<PlacedFeature> COCONUT_TREE_CHECKED = FOTPlacements.createKey("coconut_tree_checked");
    public static final ResourceKey<PlacedFeature> MANGO_TREE_CHECKED = FOTPlacements.createKey("mango_tree_checked");
    public static final ResourceKey<PlacedFeature> BANANA_TREE_CHECKED = FOTPlacements.createKey("banana_tree_checked");
    public static final ResourceKey<PlacedFeature> TROPICAL_FLOWER = FOTPlacements.createKey("tropical_flower");
    public static final ResourceKey<PlacedFeature> TREES_TROPICAL_ISLAND = FOTPlacements.createKey("trees_tropical_island");
    public static final ResourceKey<PlacedFeature> WILD_PINEAPPLE = FOTPlacements.createKey("wild_pineapple");
    public static final ResourceKey<PlacedFeature> TALL_WILD_PINEAPPLE = FOTPlacements.createKey("tall_wild_pineapple");
    public static final ResourceKey<PlacedFeature> PATCH_WILD_PINEAPPLE = FOTPlacements.createKey("patch_wild_pineapple");
    public static final ResourceKey<PlacedFeature> PATCH_MELON_TROPICAL = FOTPlacements.createKey("patch_melon_tropical");
    public static final ResourceKey<PlacedFeature> TREES_COCONUT = FOTPlacements.createKey("trees_coconut");
    public static final ResourceKey<PlacedFeature> TREES_COCONUT_TROPICAL_ISLAND = FOTPlacements.createKey("trees_coconut_tropical_island");
    public static final ResourceKey<PlacedFeature> WILD_POMEGRANATE = FOTPlacements.createKey("wild_pomegranate");
    public static final ResourceKey<PlacedFeature> TALL_WILD_POMEGRANATE = FOTPlacements.createKey("tall_wild_pomegranate");
    public static final ResourceKey<PlacedFeature> PATCH_WILD_POMEGRANATE = FOTPlacements.createKey("patch_wild_pomegranate");
    public static final ResourceKey<PlacedFeature> PATCH_TROPICAL_BUSH = FOTPlacements.createKey("patch_tropical_bush");
    public static final ResourceKey<PlacedFeature> TROPICAL_ISLAND_ROCK = FOTPlacements.createKey("tropical_island_rock");
    public static final ResourceKey<PlacedFeature> SPARSE_JUNGLE_TROPICAL_FLOWER = FOTPlacements.createKey("sparse_jungle_tropical_flower");
    public static final ResourceKey<PlacedFeature> SPARSE_JUNGLE_FRUIT_TREES = FOTPlacements.createKey("sparse_jungle_fruit_trees");
    public static final ResourceKey<PlacedFeature> SPARSE_JUNGLE_PATCH_WILD_PINEAPPLE = FOTPlacements.createKey("sparse_jungle_patch_wild_pineapple");
    public static final ResourceKey<PlacedFeature> SPARSE_JUNGLE_PATCH_WILD_POMEGRANATE = FOTPlacements.createKey("sparse_jungle_patch_wild_pomegranate");
    public static final ResourceKey<PlacedFeature> SPARSE_JUNGLE_PATCH_TROPICAL_BUSH = FOTPlacements.createKey("sparse_jungle_patch_tropical_bush");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter holderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, FISH_BONE, (Holder)holderGetter.getOrThrow(FOTFeatures.FISH_BONE), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)384), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, CountPlacement.of((IntProvider)UniformInt.of((int)4, (int)8)), BiomeFilter.biome()});
        PlacementUtils.register(context, COCONUT_TREE_CHECKED, (Holder)holderGetter.getOrThrow(FOTFeatures.COCONUT_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)FOTBlocks.COCONUT_SAPLING)});
        PlacementUtils.register(context, MANGO_TREE_CHECKED, (Holder)holderGetter.getOrThrow(FOTFeatures.MANGO_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)FOTBlocks.MANGO_SAPLING)});
        PlacementUtils.register(context, BANANA_TREE_CHECKED, (Holder)holderGetter.getOrThrow(FOTFeatures.BANANA_TREE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.filteredByBlockSurvival((Block)FOTBlocks.BANANA_SHOOTS)});
        PlacementUtils.register(context, TROPICAL_FLOWER, (Holder)holderGetter.getOrThrow(FOTFeatures.TROPICAL_FLOWER), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, TREES_TROPICAL_ISLAND, (Holder)holderGetter.getOrThrow(FOTFeatures.TREES_TROPICAL_ISLAND), (List)VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)2, (float)0.1f, (int)1)));
        PlacementUtils.register(context, PATCH_WILD_PINEAPPLE, (Holder)holderGetter.getOrThrow(FOTFeatures.PATCH_WILD_PINEAPPLE), (List)VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)12, (float)0.1f, (int)1)));
        PlacementUtils.register(context, WILD_PINEAPPLE, (Holder)holderGetter.getOrThrow(FOTFeatures.WILD_PINEAPPLE), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE)});
        PlacementUtils.register(context, TALL_WILD_PINEAPPLE, (Holder)holderGetter.getOrThrow(FOTFeatures.TALL_WILD_PINEAPPLE), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE)});
        PlacementUtils.register(context, PATCH_MELON_TROPICAL, (Holder)holderGetter.getOrThrow(FOTFeatures.PATCH_TROPICAL_MELON), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)64), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, TREES_COCONUT, (Holder)holderGetter.getOrThrow(FOTFeatures.TREES_COCONUT), (List)VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.1f, (int)1)));
        PlacementUtils.register(context, TREES_COCONUT_TROPICAL_ISLAND, (Holder)holderGetter.getOrThrow(FOTFeatures.TREES_COCONUT), (List)ImmutableList.builder().addAll((Iterable)VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)4, (float)0.1f, (int)1))).add((Object)VegetationFilter.vegetation((FloatProvider)UniformFloat.of((float)-0.2f, (float)0.0f))).add((Object)ContinentsFilter.continents((FloatProvider)UniformFloat.of((float)-1.09f, (float)-1.0f))).build());
        PlacementUtils.register(context, PATCH_WILD_POMEGRANATE, (Holder)holderGetter.getOrThrow(FOTFeatures.PATCH_WILD_POMEGRANATE), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.countExtra((int)8, (float)0.1f, (int)1), RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, WILD_POMEGRANATE, (Holder)holderGetter.getOrThrow(FOTFeatures.WILD_POMEGRANATE), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE)});
        PlacementUtils.register(context, TALL_WILD_POMEGRANATE, (Holder)holderGetter.getOrThrow(FOTFeatures.TALL_WILD_POMEGRANATE), (PlacementModifier[])new PlacementModifier[]{BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE)});
        PlacementUtils.register(context, PATCH_TROPICAL_BUSH, (Holder)holderGetter.getOrThrow(FOTFeatures.PATCH_TROPICAL_BUSH), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, TROPICAL_ISLAND_ROCK, (Holder)holderGetter.getOrThrow(FOTFeatures.TROPICAL_ISLAND_ROCK), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.GRASS_BLOCK}))});
        PlacementUtils.register(context, SPARSE_JUNGLE_TROPICAL_FLOWER, (Holder)holderGetter.getOrThrow(FOTFeatures.TROPICAL_FLOWER), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)64), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
        PlacementUtils.register(context, SPARSE_JUNGLE_FRUIT_TREES, (Holder)holderGetter.getOrThrow(FOTFeatures.SPARSE_JUNGLE_FRUIT_TREES), (List)VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)40)));
        PlacementUtils.register(context, SPARSE_JUNGLE_PATCH_WILD_PINEAPPLE, (Holder)holderGetter.getOrThrow(FOTFeatures.SPARSE_JUNGLE_PATCH_WILD_PINEAPPLE), (List)VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)16)));
        PlacementUtils.register(context, SPARSE_JUNGLE_PATCH_WILD_POMEGRANATE, (Holder)holderGetter.getOrThrow(FOTFeatures.SPARSE_JUNGLE_PATCH_WILD_POMEGRANATE), (List)VegetationPlacements.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)16)));
        PlacementUtils.register(context, SPARSE_JUNGLE_PATCH_TROPICAL_BUSH, (Holder)holderGetter.getOrThrow(FOTFeatures.PATCH_TROPICAL_BUSH), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)24), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
    }

    private static ResourceKey<PlacedFeature> createKey(String key) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)FishOfThieves.id(key));
    }
}

